using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Resources;


namespace WindowsFormsDotNet4
{
    public partial class UserControl1 : UserControl
    {
        private AxusccaxLib.AxUsccOcx m_uscc;

        public UserControl1()
        {
            InitializeComponent();

            ResourceManager resources = new ResourceManager(typeof(UserControl1));

            m_uscc = new AxusccaxLib.AxUsccOcx();

            ((ISupportInitialize)(m_uscc)).BeginInit();
            SuspendLayout();

            m_uscc.Enabled = true;
            m_uscc.Name = "axCtrl";
            m_uscc.TabIndex = 0;
            m_uscc.Dock = System.Windows.Forms.DockStyle.Fill;

            Controls.Add(m_uscc);
            Name = "AxForm";
            ((ISupportInitialize)(m_uscc)).EndInit();
            Resize += new EventHandler(AxForm_Resize);
            ResumeLayout(false);
            OnResize();
            Show();

        }

        private void OnResize()
        {
            m_uscc.Width = Width;
            m_uscc.Height = Height;
        }

        private void AxForm_Resize(object sender, EventArgs e)
        {
            OnResize();
        }

        internal void EnableActiveX(int p)
        {
            if (m_uscc != null)
                m_uscc.EnableActiveX(p);
        }

        public int ApiVersion { 
            get {
                int result = 0;
                if (m_uscc != null)
                    result = m_uscc.ApiVersion;
                return result;
            }
            
            set {
            }
        }

        internal void setLanguage(int p)
        {
            string locale = "de";
            switch (p)
            {
                case 0: locale = "de"; break;
                case 1: locale = "en"; break;
                default: locale = "de"; break;
            }
            if (m_uscc != null)
                m_uscc.SelectLanguage(locale);
        }

        internal void setPage(decimal p)
        {
            if (m_uscc != null)
                m_uscc.ShowPage((int)p, 0);
        }

        public string Version
        {
            get
            {
                string result = "";
                if (m_uscc != null)
                    result = m_uscc.Version;
                return result;
            }
        }

        public int BuildNumber
        {
            get
            {
                int result = 0;
                if (m_uscc != null)
                    result = m_uscc.BuildNumber;
                return result;
            }
        }

        public string BuildDate
        {
            get
            {
                string result = "";
                if (m_uscc != null)
                    result = m_uscc.BuildDate;
                return result;
            }
        }

        public string UsccPath
        {
            get
            {
                string result = "";
                if (m_uscc != null)
                {
                    result = m_uscc.usccOcxPath();
                }
                return result;
            }
            set
            {
                if (m_uscc != null)
                {
                    m_uscc.setUsccOcxPath(value);
                }
            }
        }

        public string ApplicationScope
        {
            get
            {
                string result = "";
                if (m_uscc != null)
                {
                    result = m_uscc.applicationScope();
                }
                return result;
            }
            set
            {
                if (m_uscc != null)
                {
                    m_uscc.setApplicationScope(value);
                }
            }
        }
    }
}
    